#NoTrayIcon
#SingleInstance, Force
Thread, priority, 1

;Files
Gui, Add, GroupBox, x32 y20 w480 h80 , Files
Gui, Add, Text, x52 y42 w90 h20 , Source Video:
Gui, Add, Text, x52 y70 w90 h20 , Destination Folder:
Gui, Add, Edit, x152 y42 w260 h20 vVideoPath, 
Gui, Add, Edit, x152 y70 w260 h20 vVideoFolder, 
Gui, Add, Button, x422 y40 w80 h20 gSelectVideo vSelectVideo, Browse...
Gui, Add, Button, x422 y70 w80 h20 gSelectFolder vSelectFolder, Browse...

;Info
Gui, Add, GroupBox, x32 y110 w480 h110 , Info
Gui, Add, Text, x52 y132 w22 h20 , Title:
Gui, Add, Text, x80 y132 w430 h20 vOTitle
Gui, Add, Text, x52 y152 w42 h20 , Duration:
Gui, Add, Text, x100 y152 w42 h20 vODuration
Gui, Add, Text, x158 y152 w22 h20 ,Size:
Gui, Add, Text, x185 y152 w60 h20 vOSize
Gui, Add, Text, x256 y152 w49 h20 ,Framerate:
Gui, Add, Text, x311 y152 w50 h20 vOFramerate
Gui, Add, Text, x377 y152 w63 h20 ,Video Bitrate:
Gui, Add, Text, x446 y152 w64 h20 vOBitrate
Gui, Add, Text, x52 y172 w102 h20 , Audio Sampling Rate:
Gui, Add, Text, x160 y172 w94 h20 vOAudiosamplingrate
Gui, Add, Text, x256 y172 w78 h20 , Audio Channels:
Gui, Add, Text, x340 y172 w154 h20 vOAudiochannels
Gui, Add, Text, x52 y192 w96 h20 , Audio Stream Layer:
Gui, Add, Text, x154 y192 w356 h20 vOAudiostreams,

;Input Video Type
Gui, Add, GroupBox, x32 y230 w170 h110 , Input Video Type
Gui, Add, Radio, x52 y255 w80 h20 vSbS, Side-by-Side
Gui, Add, Radio, x52 y285 w80 h20 vTB, Top-Bottom
Gui, Add, Radio, x142 y255 w40 h20 v2D , 2D
Gui, Add, Radio, x142 y285 w44 h20 v3DS, 3DS

;Extra Options
Gui, Add, GroupBox, x212 y230 w180 h110 , Extra Options
Gui, Add, CheckBox, x232 y250 w110 h20 vMirror, Mirror Input Video
Gui, Add, CheckBox, x232 y270 w125 h20 vDAR, Keep Aspect Ratio
Gui, Add, Checkbox, x232 y290 w104 h20 vTestFile1, Create Test File of
Gui, Add, Edit, x340 y290 w26 h20 +Center vTestFileLength, 120
Gui, Add, Text, x370 y293 w16 h20 vTestFile2, sec

Gui, Add, CheckBox, x232 y310 w155 h20 vShutdn, Shutdown PC when Done

;Multi Core
Gui, Add, GroupBox, x402 y230 w110 h110 , Multi-Core
Gui, Add, Text, x422 y256 w50 h20 , Threads:
Gui, Add, Slider, x412 y280 w90 h30 Range1-8 TickInterval1 vPcores gSliderRel AltSubmit, 1
Gui, Add, Edit, x472 y254 w20 h20 vEditText2 +Center, 1

;Video Options General
Gui, Add, GroupBox, x32 y350 w480 h80 , Video Options
Gui, Add, Button, x415 y368 w80 h20 gAdvanced vADV AltSubmit, Advanced...
Gui, Add, Text, x80 y372 w200 h20 vQual, Quality:  QScale [1= Best / 31= Worst] =
Gui, Add, Slider, x42 y390 w460 h30 Range1-31 TickInterval1 vQualityUD gSliderRel AltSubmit, 1
Gui, Add, Edit, x278 y370 w25 h20 +Center vEditText gEdit, 1
Gui, Add, Text, x80 y372 w60 h20 Hidden vBR, Bitrate:
Gui, Add, Edit, x118 y370 w32 h20 Hidden +Center vVidBitr, 6000
Gui, Add, Text, x154 y372 w40 h20 Hidden vKbpsvid, Kbps
Gui, Add, Text, x80 y400 w50 h20 Hidden vFP, Framerate:
Gui, Add, Edit, x136 y398 w32 h20 Hidden +Center vFPS, 20
Gui, Add, Text, x173 y400 w40 h20 Hidden vFPvid, fps

;Audio Options
Gui, Add, GroupBox, x32 y440 w480 h80 , Audio Options
Gui, Add, Text, x65 y462 w32 h20 , Bitrate:
Gui, Add, ComboBox, x102 y460 w42 vAudBitr, 32|64|128||160|192|224
Gui, Add, Text, x150 y462 w30 h20 , Kbps
Gui, Add, Text, x198 y462 w60 h20 , Set Volume:
Gui, Add, Edit, x260 y459 w50 h22 +Center vVolEdit,
Gui, Add, UpDown, x290 y459 w20 Range0-400 vVolumeUD , 100 UpDown
Gui, Add, Text, x316 y462 w20 h20 , `%
Gui, Add, Text, x355 y462 w96 h20 , Audio Stream Layer:
Gui, Add, Edit, x455 y460 w20 h20 vAudStr +Center, 1
Gui, Add, Text, x65 y492 w72 h20 , Sampling Rate:
Gui, Add, ComboBox, x141 y490 w54 vAudiorate, 8000|11025|16000|22050|32000|44100||48000|96000
Gui, Add, Text, x201 y492 w28 h20 , Hz
Gui, Add, Radio, x278 y492 h20 Checked vStereo, Stereo
Gui, Add, Radio, x347 y492 h20 vMono, Mono
Gui, Add, Radio, x412 y492 h20 vNoSound, No Sound

;Progress
Gui, Add, GroupBox, x32 y530 w480 h90 , Progress
Gui, Add, Text, x52 y550 w80 h20 vLSVideo, Left Side Video:
Gui, Add, Text, x52 y570 w90 h20 vRSVideo, Right Side Video:
Gui, Add, Text, x52 y590 w70 h20 vFinVideo, Final Video:
Gui, Add, Progress, x142 y552 w350 h10 -Smooth vProgressLeft, 0
Gui, Add, Progress, x142 y572 w350 h10 -Smooth vProgressRight, 0
Gui, Add, Progress, x142 y592 w350 h10 -Smooth vProgressFinal, 0
Gui, Add, Text, x52 y570 w80 h20 Hidden vPreCon, Pre-Conversion:
Gui, Add, Progress, x142 y572 w350 h10 Hidden -Smooth vProgressPreCon, 0

; Gui, Add, Text, x142 y600 w550 vTextinfo, 0 ; TESTINGS

;Main Window
Gui, Add, Button, x32 y630 w480 h30 gConvert vConvert, Convert
Gui, Show, x283 y131 h678 w552 Center, 3DS Video v1.32

Advanced := 0
IfExist, settings.ini
	IniRead, VidFoldSet, settings.ini, Settings, VidFolder
GuiControl,, VideoFolder, %VidFoldSet%
return

GuiClose:
ExitApp

Done:
Gui, Destroy
gosub, EnableGUI
return

SelectVideo:
FileSelectFile, PathToVideo,,, Select video, *.*
GuiControl,, VideoPath, %PathToVideo%

RunWait, %Comspec% /min /c ffmpeg -i "%PathToVideo%" > "%A_Temp%\tsize.txt" 2>>&1,, Hide
FileRead, TSize, %A_Temp%\tsize.txt

;Get Title and Extension
SplitPath, PathToVideo,,, orig_ext, orig_title
GuiControl,, OTitle, %orig_title%
;RegExMatch(PathToVideo, "i)(?<=\\)+[^\\]+(?=\.)+(?!>=.*\.)+", orig_title) ; CLEANER BY USAGE OF 'SPLITPASS' ABOVE
;RegExMatch(PathToVideo, "i)[\d\w]+$", orig_ext) ; CLEANER BY USAGE OF 'SPLITPASS' ABOVE

;Get Duration
If RegExMatch(TSize, "im)(?<=^  Duration: )([\d:.]+)", orig_duration) != 0
	GuiControl,, ODuration, %orig_duration%
else
	GuiControl,, ODuration, n.a.
global total_time := (SubStr(orig_duration, 1, 2)*3600) + (SubStr(orig_duration, 4, 2)*60) + SubStr(orig_duration, 7, 2) + SubStr(orig_duration, 9, 3)

;Get Framerate
If RegExMatch(TSize, "im)[\d.]+(?=.tbr)+", orig_fps) != 0
	GuiControl,, OFramerate, %orig_fps% fps
else
	GuiControl,, OFramerate, n.a.

global max_fps := Floor(orig_fps)
if max_fps > 30
	global simplemode_fps := "30"
else
	global simplemode_fps := max_fps
; GuiControl,, Textinfo, orig_fps: %orig_fps% <-> max_fps: %max_fps% | Ext:%TestExt%, Name:%TestName% ; TESTINGS

;Get Bitrate
If RegExMatch(TSize, "im)(?<= bitrate: )([\d]+)", orig_bitrate) != 0
	GuiControl,, OBitrate, %orig_bitrate% Kbps
else
	GuiControl,, OBitrate, n.a.

;Get Size
If RegExMatch(TSize, "im)[\d.]+x[\d.]+(?= \[|,)", orig_size) != 0
	GuiControl,, OSize, %orig_size%
else
	GuiControl,, OSize, n.a.

;Get Audiosamplerate
If RegExMatch(TSize, "im)[\d.]+(?=.Hz)+", orig_audiosamplingrate_a) != 0
 {
	RegExMatch(TSize, "ims)[\d.]+(?=.Hz)+(?!.*Audio:)+", orig_audiosamplingrate_b)
	if orig_audiosamplingrate_a = %orig_audiosamplingrate_b%
		GuiControl,, OAudiosamplingrate, %orig_audiosamplingrate_a% Hz
	else		
		GuiControl,, OAudiosamplingrate, %orig_audiosamplingrate_a%/%orig_audiosamplingrate_b% Hz
	}
else
	GuiControl,, OAudiosamplingrate, n.a.

;Get Soundchannels
If RegExMatch(TSize, "im)(?<=Hz, )[\d\s\w]+", orig_audiochannels) != 0
	GuiControl,, OAudiochannels, %orig_audiochannels%
else
	GuiControl,, OAudiochannels, n.a.

;Get Audiostreams
if orig_ext = mkv
{
	next_pos := 1
	Loop
	{
		current_pos := RegExMatch(TSize, "im)(?<=Stream #0:)+(\d\(\w\w\w\)|\d)+(?=.*: Audio:)", orig_audiostream%A_Index%, next_pos)
		if current_pos = 0
			break
		if orig_audiostreams =
			orig_audiostreams := orig_audiostreams . orig_audiostream%A_Index%
		else
			orig_audiostreams := orig_audiostreams . "  |  " . orig_audiostream%A_Index%
		next_pos := (current_pos + 1)
	}
}
if orig_audiostreams =
{
 	RegExMatch(TSize, "im)(?<=Stream #0:)+(\d)+(?=.*: Audio:)", orig_audiostreams)
	}	
if orig_audiostreams =
	GuiControl,, OAudiostreams, n.a.
else
	if orig_audiostreams = 0
		GuiControl,, OAudiostreams, 1
	else
		GuiControl,, OAudiostreams, %orig_audiostreams%
orig_audiostreams := ""

return

SelectFolder:
FileSelectFolder, PathToFolder,,, Select video folder
GuiControl,, VideoFolder, %PathToFolder%
IniWrite, %PathToFolder%, settings.ini, Settings, VidFolder
return

SliderRel:
Gui, Submit, NoHide
GuiControl,, EditText, %QualityUD%
GuiControl,, EditText2, %Pcores%
Return

Edit:
Gui, Submit, Nohide
GuiControl,, QualityUD, %EditText%
GuiControl,, Pcores, %EditText2%
Return

Advanced:
if (Advanced = 0)
{
	GuiControl, Hide, Qual
	GuiControl, Hide, QualityUD
	GuiControl, Hide, Bar
	GuiControl, Hide, EditText
	GuiControl, show, FP
	GuiControl, show, BR
	GuiControl, show, VidBitr
	GuiControl, show, FPS
	GuiControl, show, Kbpsvid
	GuiControl, show, FPvid
	Gui, Submit, Nohide
	GuiControl,, ADV, Simple...
		
	Advanced := 1
	return
}
if (Advanced = 1)
{
	GuiControl, Show, Qual
	GuiControl, Show, QualityUD
	GuiControl, Show, Bar
	GuiControl, Show, EditText
	GuiControl, Hide, FP
	GuiControl, Hide, BR
	GuiControl, Hide, VidBitr
	GuiControl, Hide, FPS
	GuiControl, Hide, Kbpsvid
	GuiControl, Hide, FPvid
	Gui, Submit, Nohide
	GuiControl,, ADV, Advanced...
	
	Advanced := 0
	return
}
return

Convert:
Gui, submit, NoHide

FileDelete, %A_Temp%\tsize.txt
FileDelete, %A_Temp%\psize.txt
global file_prog := 0
global output
global Starttime
global current_time
Volume := round((256*VolumeUD)/100)

;disable/reset GUI elements
GuiControl, Disable, VideoPath
GuiControl, Disable, VideoFolder 
GuiControl, Disable, SelectVideo
GuiControl, Disable, SelectFolder
GuiControl, Disable, SbS
GuiControl, Disable, TB
GuiControl, Disable, 2D
GuiControl, Disable, 3DS
GuiControl, Disable, QualityUD 
GuiControl, Disable, EditText
GuiControl, Disable, ADV
GuiControl, Disable, VidBitr
GuiControl, Disable, FPS
GuiControl, Disable, AudBitr
GuiControl, Disable, VolEdit
GuiControl, Disable, VolumeUD
GuiControl, Disable, AudStr 
GuiControl, Disable, Mirror
GuiControl, Disable, DAR
GuiControl, Disable, TestFile1
GuiControl, Disable, TestFile2
GuiControl, Disable, TestFileLength
GuiControl, Disable, Shutdn
GuiControl, Disable, Pcores
GuiControl, Disable, EditText2 
GuiControl, Disable, Convert
GuiControl, Disable, Audiorate
GuiControl, Disable, Stereo
GuiControl, Disable, Mono
GuiControl, Disable, NoSound
GuiControl,, ProgressLeft,0
GuiControl,, ProgressRight,0
GuiControl,, ProgressFinal,0
GuiControl,, ProgressPreCon,0

;do some checks
if !VideoPath
{
	MsgBox,,Error!, Error! Select Source Video
	gosub, EnableGUI
	return
	}
if !VideoFolder
{
	MsgBox,,Error!, Error! Select Destination Video Folder
	gosub, EnableGUI
	return
	}
if !TB && !SbS && !2D && !3DS
{
	MsgBox,,Error!, Error! Select Input Video Type
	gosub, EnableGUI
	return
	}
IfInString, VideoFolder, %A_Space%
{
	MsgBox,,Error!,Error! Please choose a destination folder without spaces!
	gosub, EnableGUI
	return
	}
global total_time := (SubStr(orig_duration, 1, 2)*3600) + (SubStr(orig_duration, 4, 2)*60) + SubStr(orig_duration, 7, 2) + SubStr(orig_duration, 9, 3)
If (TestFile1 = 1) and (total_time > TestFileLength)
{
	global testfile_option := "-t " . TestFileLength . " "
	global total_time := TestFileLength
		}
else
	testfile_option := ""
If Stereo
	ACChannels := "c 2"
else
	if Mono
		ACChannels := "c 1"
	else
		ACChannels := "n"
If (Advanced = 1)
{
	If (FPS > max_fps) and (3DS != 1)
	{
		MsgBox, 4 , Warning!,The chosen video framerate is greater than the framerate of the source video.`nThe conversion process is going to take more time than usual.`nDo you want to proceed?
		IfMsgBox Yes
		{
			gosub, Preconversion
			}
		IfMsgBox No
		{
			Gui, Submit, Nohide
			GuiControl,, FPS, %max_fps%
			gosub, EnableGUI
			return
			}
	}
}


;Top-bottom
if TB
{
	mapSettings := "-map 0:0 -map 0:1 -map 1:0"
	FinalWidth := 400
	FinalHeight := 480
	crop1 := 400
	crop2 := 240
	comma := ","
		
	if (DAR)
	{
		GoSub, KeepAspect
	
		newHeight := Round((400*Height)/Width)
		newWidth := Round((240*Width)/Height)
		
		If (newHeight < 240)
		{
			FinalHeight := Round(newHeight/16)*16
			crop2 := FinalHeight
			FinalHeight := 2*FinalHeight 
 						
		}
		If (newHeight > 240)
		{
			FinalWidth := Round(newWidth/16)*16
			crop1 := FinalWidth
		}
	}
	if (Mirror)
	{
		mapSettings := "-map 1:0 -map 0:1 -map 0:0"
	}
	if (Mirror && DAR)
	{
		GoSub, KeepAspect
		mapSettings := "-map 1:0 -map 0:1 -map 0:0"
		newHeight := Round((400*Height)/Width)
		newWidth := Round((240*Width)/Height)
		
		If (newHeight < 240)
		{
			FinalHeight := Round(newHeight/16)*16
			crop2 := FinalHeight
			FinalHeight := 2*FinalHeight 
 						
		}
		If (newHeight > 240)
		{
			FinalWidth := Round((newWidth/16)*16)
			crop1 := FinalWidth
		}
	}
	
	if (Advanced = 0)
	{
	Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:0:0" -r %simplemode_fps% -vcodec mjpeg -map 0:0 -map 0:%AudStr% -qscale %QualityUD% -acodec libmp3lame -ar %Audiorate% -b:a %AudBitr%k -vol %Volume% -ac 2 %testfile_option%"left.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressLeft"
	GoSub, Progress
	;Process, WaitClose, ffmpeg
	GuiControl,, ProgressLeft, 100
	
	Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:0:%crop2%" -r %simplemode_fps% -vcodec mjpeg -map 0:0 -map 0:%AudStr% -qscale %QualityUD% -an %testfile_option%"right.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressRight"
	GoSub, Progress
	;Process, WaitClose, ffmpeg
	GuiControl,, ProgressRight, 100
	}
	if (Advanced = 1)
	{
	Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:0:0" -vcodec mjpeg -map 0:0 -map 0:%AudStr% -r %FPS% -b:v %VidBitr%k -acodec libmp3lame -ar %Audiorate% -vol %Volume% -b:a %AudBitr%k -ac 2 %testfile_option%"left.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressLeft"
	GoSub, Progress
	;Process, WaitClose, ffmpeg
	GuiControl,, ProgressLeft, 100
	
	Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:0:%crop2%" -vcodec mjpeg -map 0:0 -map 0:%AudStr% -r %FPS% -b:v %VidBitr%k -an %testfile_option%"right.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressRight"
	GoSub, Progress
	;Process, WaitClose, ffmpeg
	GuiControl,, ProgressRight, 100
	}
	
	Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "left.avi" -i "right.avi" -vcodec copy -acodec adpcm_ima_wav -a%ACChannels% -vcodec copy %mapSettings% "temp.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressFinal"
	GoSub, Progress
	;Process, WaitClose, ffmpeg.exe
	
	gosub, FileSplit
	
	FileDelete, left.avi
	FileDelete, right.avi
	FileDelete, preconv.wmv
	FileDelete, temp.avi
	FileDelete, %A_Temp%\tsize.txt
	GuiControl,, ProgressFinal, 100
			
	if (Shutdn)
	{
		Sleep, 6000
		Shutdown, 1+8
		ExitApp
	}	
	Else
	{
	Gui, New
	Gui, Add, Button, x51 y50 w70 h30 Default gDone, OK
	Gui, Add, Text, x41 y20 w90 h20 , Encoding Finished!
	Gui, Show, h105 w177, DONE!
	}
	
}

;Side-by-side
if SbS
{
	mapSettings := "-map 0:0 -map 0:1 -map 1:0"
	FinalWidth := 800
	FinalHeight := 240
	crop1 := 400
	crop2 := 240
	comma := ","
		
	if (DAR)
	{
		GoSub, KeepAspect
	
		newHeight := Round((400*Height)/Width)
		newWidth := Round((240*Width)/Height)
		
		If (newHeight < 240)
		{
			FinalHeight := Round(newHeight/16)*16
			crop2 := FinalHeight
 						
		}
		If (newHeight > 240)
		{
			FinalWidth := Round(newWidth/16)*16
			crop1 := FinalWidth
			FinalWidth := 2*FinalWidth 
		}
	}
	if (Mirror)
	{
		mapSettings := "-map 1:0 -map 0:1 -map 0:0"
	}
	if (Mirror && DAR)
	{
		GoSub, KeepAspect
		mapSettings := "-map 1:0 -map 0:1 -map 0:0"
		newHeight := Round((400*Height)/Width)
		newWidth := Round((240*Width)/Height)
		
		If (newHeight < 240)
		{
			FinalHeight := Round(newHeight/16)*16
			crop2 := FinalHeight
 						
		}
		If (newHeight > 240)
		{
			FinalWidth := Round(newWidth/16)*16
			crop1 := FinalWidth
			FinalWidth := 2*FinalWidth
		}
		
	}
		
	if (Advanced = 0)
	{
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:0:0" -r %simplemode_fps% -vcodec mjpeg -map 0:0 -map 0:%AudStr% -qscale %QualityUD% -acodec libmp3lame -ar %Audiorate% -vol %Volume% -b:a %AudBitr%k -ac 2 %testfile_option%"left.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
		output := "ProgressLeft"
		GoSub, Progress
		;Process, WaitClose, ffmpeg
		GuiControl,, ProgressLeft, 100
		
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:%crop1%:0" -r %simplemode_fps% -vcodec mjpeg -map 0:0 -map 0:%AudStr% -qscale %QualityUD% -an %testfile_option%"right.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
		output := "ProgressRight"
		GoSub, Progress
		;Process, WaitClose, ffmpeg
		GuiControl,, ProgressRight, 100
	}
	if (Advanced = 1)
	{
			Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:0:0" -vcodec mjpeg -map 0:0 -map 0:%AudStr% -r %FPS% -b:v %VidBitr%k -acodec libmp3lame -ar %Audiorate% -vol %Volume% -b:a %AudBitr%k -ac 2 %testfile_option%"left.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
		output := "ProgressLeft"
		GoSub, Progress
		;Process, WaitClose, ffmpeg
		GuiControl,, ProgressLeft, 100
		
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%%comma%crop=%crop1%:%crop2%:%crop1%:0" -vcodec mjpeg -map 0:0 -map 0:%AudStr% -r %FPS% -b:v %VidBitr%k -an %testfile_option%"right.avi" > "%A_Temp%\psize.txt"2>>&1,, Hide
		output := "ProgressRight"
		GoSub, Progress
		;Process, WaitClose, ffmpeg
		GuiControl,, ProgressRight, 100	
	}

	
	Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "left.avi" -i "right.avi" -vcodec copy -acodec adpcm_ima_wav -b:a %AudBitr%k -a%ACChannels% -vcodec copy %mapSettings% "temp.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressFinal"
	GoSub, Progress
	;Process, WaitClose, ffmpeg.exe
	
	gosub, FileSplit
	
	FileDelete, left.avi
	FileDelete, right.avi
	FileDelete, preconv.wmv
	FileDelete, temp.avi
	FileDelete, %A_Temp%\tsize.txt
	GuiControl,, ProgressFinal, 100
	
	if (Shutdn)
	{
		Sleep, 6000
		Shutdown, 1+8
		ExitApp
	}	
	Else
	{
	Gui, New
	Gui, Add, Button, x51 y50 w70 h30 Default gDone, OK
	Gui, Add, Text, x41 y20 w90 h20 , Encoding Finished!
	Gui, Show, h105 w177, DONE!
	}
}

;2D
if 2D
{
	GuiControl, Disable , LSVideo
	GuiControl, Disable , RSVideo
	GuiControl, Disable , ProgressLeft
	GuiControl, Disable , ProgressRight
	FinalWidth := 400
	FinalHeight := 240
	
	if (DAR)
	{
		GoSub, KeepAspect
	
		newHeight := Round((400*Height)/Width)
		newWidth := Round((240*Width)/Height)
		
		If (newHeight < 240)
		{
			FinalHeight := Round(newHeight/16)*16
		}
	
		If (newHeight > 240)
		{
		FinalWidth := Round(newWidth/16)*16
		}
	}
	
	if (Advanced = 0)
	{
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%" -r %simplemode_fps% -vcodec mjpeg -map 0:0 -map 0:%AudStr% -qscale %QualityUD% -acodec adpcm_ima_wav -ar %Audiorate% -a%ACChannels% -vol %Volume% -b:a %AudBitr%k %testfile_option%"temp.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
		output := "ProgressFinal"
		GoSub, Progress
		;Process, WaitClose, ffmpeg.exe
	}
	if (Advanced = 1)
	{
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -vf "scale=%FinalWidth%:%FinalHeight%" -r %FPS% -vcodec mjpeg -map 0:0 -map 0:%AudStr% -b:v %VidBitr%k -acodec adpcm_ima_wav -a%ACChannels% -vol %Volume% -ar %Audiorate% -b:a %AudBitr%k %testfile_option%"temp.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
		output := "ProgressFinal"
		GoSub, Progress
		;Process, WaitClose, ffmpeg.exe
	}	
		
	gosub, FileSplit
	
	FileDelete, preconv.wmv
	FileDelete, temp.avi
	FileDelete, %A_Temp%\tsize.txt
	GuiControl,, ProgressFinal, 100
		
	if (Shutdn)
	{
		Sleep, 6000
		Shutdown, 1+8
		ExitApp
	}	
	Else
	{
	Gui, New
	Gui, Add, Button, x51 y50 w70 h30 Default gDone, OK
	Gui, Add, Text, x41 y20 w90 h20 , Encoding Finished!
	Gui, Show, h105 w177, DONE!
	}
}

;3DS
if 3DS
{
	Loop 
		{
		   FileName := VideoFolder . "\3D_YOUTUBE_" . SubStr("000" . A_Index,-3) . ".AVI"
		   IfExist, %FileName% 
			  continue 
		   break 
		}
	
	Run, %Comspec% /min /c title Converting && ffmpeg -threads %Pcores% -y -i "%VideoPath%" -map 0:0 -map 0:1 -vcodec rawvideo -s 240x240 -vf pad=480:240:0:0:violet "left.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressLeft"
	GoSub, Progress
	;Process, WaitClose, ffmpeg
	GuiControl,, ProgressLeft, 100
	
	Run, %Comspec% /min /c title Converting && ffmpeg -threads %Pcores% -y -i "%VideoPath%" -map 0:2 -map 0:1 -vcodec rawvideo -s 240x240 "right.avi" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressRight"
	GoSub, Progress
	;Process, WaitClose, ffmpeg
	GuiControl,, ProgressRight, 100
	
	Run, %Comspec% /min /c title Converting && ffmpeg -threads %Pcores% -y -i "left.avi" -vf "movie=right.avi [ovl]; [in][ovl] overlay=240:0 [out]" -q 1 "%FileName%" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressFinal"
	GoSub, Progress
	;Process, WaitClose, ffmpeg.exe
	
	FileDelete, left.avi
	FileDelete, right.avi
	FileDelete, %A_Temp%\tsize.txt
	GuiControl,, ProgressFinal, 100
	
	if (Shutdn)
	{
		Sleep, 6000
		Shutdown, 1+8
		ExitApp
	}	
	Else
	{
	Gui, New
	Gui, Add, Button, x51 y50 w70 h30 Default gDone, OK
	Gui, Add, Text, x41 y20 w90 h20 , Encoding Finished!
	Gui, Show, h105 w177, DONE!
	}
	
}

return

FileSplit:
Loop
	{
		Loop 
		{
		   FileName := VideoFolder . "\VID_" . SubStr("000" . A_Index,-3) . ".AVI"
		   IfExist, %FileName% 
			  continue 
		   break 
		}
		Starttime := (A_Index - 1) * 599
		if (A_Index = 1)
			Starttime := 1
		EndTime := 599
		if Starttime > %total_time%
			break
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -i "temp.avi" -vcodec copy -acodec adpcm_ima_wav -b:a %AudBitr%k -a%ACChannels% -map 0 -ss %StartTime% -t %EndTime% %FileName% > "%A_Temp%\psize.txt" 2>>&1,, Hide
		GoSub ProgressSplit
		;Process, Waitclose, ffmpeg.exe
	}
return

Progress:
;Process, Wait, ffmpeg.exe
Loop
{
	FileRead, PSize, %A_Temp%\psize.txt
	RegExMatch(PSize, "ism)(?<=time=)+[\d:.]+(?!.*time=)+", temp2)
	current_time := (SubStr(temp2, 1, 2)*3600) + (SubStr(temp2, 4, 2)*60) + SubStr(temp2, 7, 2) + SubStr(temp2, 9, 3)
	If (output = "ProgressFinal") and (3DS != 1)
		file_prog := (current_time/total_time)*50
	Else
		file_prog := (current_time/total_time)*99.5
	file_percent := floor(file_prog)
	GuiControl,, %output%, %file_prog%
	If RegExMatch(PSize, "ims)muxing overhead")
	{
		FileDelete, %A_Temp%\psize.txt
		Break
	}
	Sleep, 500
}
return

ProgressSplit:
;Process, Wait, ffmpeg.exe
Loop
{
	FileRead, PSize, %A_Temp%\psize.txt
	RegExMatch(PSize, "i)time=[\d:.]+(?!.*time=)+", temp2)
	current_time := (SubStr(temp2, 6, 2)*3600) + (SubStr(temp2, 9, 2)*60) + SubStr(temp2, 12, 2) + SubStr(temp2, 14, 3) ; ADDED
    file_prog := 50+(((current_time + Starttime)/total_time)*49.5)
	file_percent := floor(file_prog)
	If current_time !=
		GuiControl,, %output%, %file_prog%
	If RegExMatch(PSize, "ims)muxing overhead")
	{
		FileDelete, %A_Temp%\psize.txt
		Break
	}
	Sleep, 300
}
return

;re-enable GUI elements
EnableGUI:
Gui, submit, NoHide
GuiControl, Enable, VideoFolder 
GuiControl, Enable, SelectVideo
GuiControl, Enable, SelectFolder
GuiControl, Enable, VideoPath
GuiControl, Enable, SbS
GuiControl, Enable, TB
GuiControl, Enable, 2D
GuiControl, Enable, 3DS
GuiControl, Enable, QualityUD 
GuiControl, Enable, EditText
GuiControl, Enable, ADV
GuiControl, Enable, VidBitr
GuiControl, Enable, FPS
GuiControl, Enable, AudBitr
GuiControl, Enable, Volume
GuiControl, Enable, AudStr 
GuiControl, Enable, Mirror
GuiControl, Enable, DAR
GuiControl, Enable, Shutdn
GuiControl, Enable, Pcores
GuiControl, Enable, EditText2 
GuiControl, Enable, Convert
GuiControl, Enable, ProgressLeft
GuiControl, Enable, ProgressRight
GuiControl, Enable, LSVideo
GuiControl, Enable, RSVideo
GuiControl, Enable, Audiorate
GuiControl, Enable, Stereo
GuiControl, Enable, Mono
GuiControl, Enable, NoSound
GuiControl, Enable, VolEdit
GuiControl, Enable, VolumeUD
GuiControl, Enable, TestFile1
GuiControl, Enable, TestFile2
GuiControl, Enable, TestFileLength
Return

KeepAspect:
File1 := VideoPath

hModule := DllCall( "LoadLibrary", Str, "MediaInfo.dll" )

hnd := MediaInfo_New()
stat := MediaInfo_Open( hnd, File1 )
;DDPD := MediaInfo_Get( hnd, 1,0, "Bit rate", 1 ) ; TESTINGS
;FileAppend, %DDPD%, %A_WorkingDir%\testtt.txt ; TESTINGS

;GET VIDEO INFO Width&Height
Width := MediaInfo_Get( hnd, 1,0, "Width", 1 )
Height := MediaInfo_Get( hnd, 1,0, "Height", 1 )

MediaInfo_Close( hnd )

MediaInfo_New() {
 Return DllCall( "mediainfo\MediaInfo" ( A_IsUnicode ? "" : "A" ) "_New" )
}

MediaInfo_Open( hnd, MediaFile ) {
 Return DllCall( "mediainfo.dll\MediaInfo" ( A_IsUnicode ? "" : "A" ) "_Open", UInt,hnd
               , Str,MediaFile, UInt )
}

MediaInfo_Get( hnd, StrK=0, StrN=0, Comm="", InfK=0, Srch=0 ) {
 Return DllCall( "mediainfo.dll\MediaInfo" ( A_IsUnicode ? "" : "A" ) "_Get", UInt,hnd
               , Int,StrK, Int,StrN, Str,Comm, Int,InfK, Int,Sech, Str )
}

MediaInfo_Close( hnd ) {
 Return DllCall( "mediainfo\MediaInfo" ( A_IsUnicode ? "" : "A" ) "_Close", UInt,hnd )
}
Return

;Pre-Conversion
PreConversion:
	GuiControl, Hide, LSVideo
	GuiControl, Hide, RSVideo
	GuiControl, Hide, FinVideo
	GuiControl, Hide, ProgressLeft
	GuiControl, Hide, ProgressRight
	GuiControl, Hide, ProgressFinal
	GuiControl, Show, PreCon
	GuiControl, Show, ProgressPreCon
	If (Advanced = 0)
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -r %simplemode_fps% -qscale %QualityUD% -map 0:0 -map 0:%AudStr% -b:a %AudBitr%k -ac 2 %testfile_option%"%A_WorkingDir%\preconv.wmv" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	If (Advanced = 1)
		Run, %Comspec% /min /c title Converting && ffmpeg.exe -threads %Pcores% -y -i "%VideoPath%" -r %FPS% -b:v %VidBitr%k -map 0:0 -map 0:%AudStr% -b:a %AudBitr%k -ac 2 %testfile_option%"%A_WorkingDir%\preconv.wmv" > "%A_Temp%\psize.txt" 2>>&1,, Hide
	output := "ProgressPreCon"
	GoSub, Progress
	Process, WaitClose, ffmpeg
	GuiControl,, ProgressPreCon, 100
	VideoPath := A_WorkingDir . "\preconv.wmv"
	AudStr := 1
	GuiControl, Hide, PreCon
	GuiControl, Hide, ProgressPreCon
	GuiControl, Show, LSVideo
	GuiControl, Show, RSVideo
	GuiControl, Show, FinVideo
	GuiControl, Show, ProgressLeft
	GuiControl, Show, ProgressRight
	GuiControl, Show, ProgressFinal
return